#ifndef __COMPAT_HIGHMEM_H__
#   define __COMPAT_HIGHMEM_H__


/*
 *  BIGMEM  (4 GB)         support appeared in 2.3.16: kmap() API added
 *  HIGHMEM (4 GB + 64 GB) support appeared in 2.3.23: kmap() API modified
 *  In 2.3.27, kmap() API modified again
 *
 *   --hpreg
 */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 3, 27)
#   include <linux/highmem.h>
#else
/* For page_address --hpreg */
#   include <linux/pagemap.h>

#   define kmap(_page) (void*)page_address(_page)
#   define kunmap(_page)
#endif

#endif /* __COMPAT_HIGHMEM_H__ */
